<?php
/**
 * Template to show the bar.
 *
 * @package SBFW
 */

use StorePulse\StoreGrowth\Modules\FloatingNotificationBar\Helper;

$settings      = Helper::get_settings();
$banner_text   = Helper::get_banner_text( $settings );
$banner_icon   = Helper::get_banner_icon( $settings );
$button_text   = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'ac_button_text', 'Shop Now' );
$button_action = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'button_action', 'ba-url-redirect' );
$redirect_url  = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'redirect_url', '#' );

?>
<div class="spsg-floating-notification-bar-wrapper">
	<div class="spsg-floating-notification-bar">
		<div class='spsg-floating-notification-bar-icon'>
			<?php if ( 'notify-bar-icon-1' === $banner_icon ) : ?>
				<svg viewBox="0 0 200 200" style="width: 40px; height: 40px">
					<g>
						<path
							d='M72.8,172.4c0.9,0,1.8-0.3,2.5-1l54.5-54.5c1.4-1.4,1.4-3.6,0-4.9c-1.4-1.4-3.6-1.4-4.9,0l-54.5,54.5   c-1.4,1.4-1.4,3.6,0,4.9C71,172.1,71.9,172.4,72.8,172.4z' />
						<path
							d='M91.3,131.5c3.6,0,7.2-1.4,10-4.1c2.7-2.7,4.1-6.2,4.1-10c0-3.8-1.5-7.3-4.1-10c-2.7-2.7-6.2-4.1-10-4.1   c-3.8,0-7.3,1.5-10,4.1c-2.7,2.7-4.1,6.2-4.1,10c0,3.8,1.5,7.3,4.1,10C84.1,130.1,87.7,131.5,91.3,131.5z M86.3,112.4L86.3,112.4   c1.3-1.3,3.1-2.1,5-2.1s3.7,0.7,5,2.1c1.3,1.3,2.1,3.1,2.1,5c0,1.9-0.7,3.7-2.1,5c-2.8,2.8-7.3,2.8-10,0c-1.3-1.3-2.1-3.1-2.1-5   C84.2,115.5,84.9,113.7,86.3,112.4z' />
						<path
							d='M98.8,155.9c-2.7,2.7-4.1,6.2-4.1,10s1.5,7.3,4.1,10c2.7,2.7,6.2,4.1,10,4.1c3.8,0,7.3-1.5,10-4.1c5.5-5.5,5.5-14.4,0-19.9   C113.2,150.4,104.3,150.4,98.8,155.9z M113.7,170.9c-1.3,1.3-3.1,2.1-5,2.1c-1.9,0-3.7-0.7-5-2.1s-2.1-3.1-2.1-5s0.7-3.7,2.1-5   c1.4-1.4,3.2-2.1,5-2.1c1.8,0,3.6,0.7,5,2.1c1.3,1.3,2.1,3.1,2.1,5S115.1,169.6,113.7,170.9z' />
						<path
							d='M185,54.7h-41.5c6-5.2,9.7-12.8,9.7-21.4c0-15.6-12.7-28.4-28.4-28.4c-10.7,0-20,6-24.9,14.7C95.2,11,85.8,5,75.1,5   C59.5,5,46.8,17.7,46.8,33.4c0,8.5,3.8,16.2,9.7,21.4H15c-5.2,0-9.5,4.3-9.5,9.5v21.6c0,5.2,4.3,9.5,9.5,9.5h2.6v86.2   c0,7.4,6.1,13.5,13.5,13.5h137.9c7.4,0,13.5-6.1,13.5-13.5V95.3h2.6c5.2,0,9.5-4.3,9.5-9.5V64.2C194.5,59,190.3,54.7,185,54.7z    M124.9,12c11.8,0,21.4,9.6,21.4,21.4c0,11.8-9.6,21.4-21.4,21.4h-21.4V33.4C103.5,21.6,113.1,12,124.9,12z M53.8,33.4   c0-11.8,9.6-21.4,21.4-21.4c11.8,0,21.4,9.6,21.4,21.4v21.4H75.1C63.3,54.7,53.8,45.2,53.8,33.4z M175.4,181.5   c0,3.6-2.9,6.5-6.5,6.5H31.1c-3.6,0-6.5-2.9-6.5-6.5V95.3h150.9V181.5z' />
					</g>
				</svg>
			<?php endif; ?>

			<?php if ( 'notify-bar-icon-2' === $banner_icon ) : ?>
				<svg viewBox="0 0 200 200" style="width: 40px; height: 40px">
					<g>
						<path
							d='M82.9,90.7c-3.6-3.6-3.6-9.5,0-13.2c3.6-3.6,9.5-3.6,13.2,0c3.6,3.6,3.6,9.5,0,13.2C92.4,94.3,86.5,94.3,82.9,90.7z' />
						<path
							d='M117.1,136.2c-1.8-1.8-4.2-2.7-6.6-2.7c-2.4,0-4.8,0.9-6.6,2.7c-3.6,3.6-3.6,9.5,0,13.2c3.6,3.6,9.5,3.6,13.2,0   C120.8,145.7,120.8,139.8,117.1,136.2z M117.1,136.2c-1.8-1.8-4.2-2.7-6.6-2.7c-2.4,0-4.8,0.9-6.6,2.7c-3.6,3.6-3.6,9.5,0,13.2   c3.6,3.6,9.5,3.6,13.2,0C120.8,145.7,120.8,139.8,117.1,136.2z M159.8,50.6l-47-47L79.1,37.3V11.6L40.2,50.6   c-16,16-24.8,37.2-24.8,59.8c0,22.6,8.8,43.8,24.8,59.8c16,16,37.2,24.8,59.8,24.8c11.3,0,22.3-2.2,32.4-6.4   c10.1-4.2,19.5-10.4,27.4-18.4c16-16,24.8-37.2,24.8-59.8C184.6,87.8,175.8,66.5,159.8,50.6z M77.9,72.6c3.2-3.2,7.4-4.8,11.5-4.8   c4.2,0,8.3,1.6,11.5,4.8c6.4,6.4,6.4,16.7,0,23.1c-3.2,3.2-7.4,4.8-11.5,4.8c-4.2,0-8.4-1.6-11.5-4.8   C71.6,89.3,71.6,78.9,77.9,72.6z M122.1,154.3c-3.1,3.1-7.2,4.8-11.5,4.8c-4.3,0-8.4-1.7-11.5-4.8c-3.1-3.1-4.8-7.2-4.8-11.5   s1.7-8.5,4.8-11.5c3.1-3.1,7.2-4.8,11.5-4.8c4.4,0,8.5,1.7,11.5,4.8c3.1,3.1,4.8,7.2,4.8,11.5S125.2,151.2,122.1,154.3z M135.4,83   l-65.9,65.9c-0.7,0.7-1.6,1-2.5,1c-0.9,0-1.8-0.3-2.5-1c-1.4-1.4-1.4-3.6,0-5L130.5,78c1.4-1.4,3.6-1.4,4.9,0   C136.8,79.4,136.8,81.6,135.4,83z M110.5,133.4c-2.4,0-4.8,0.9-6.6,2.7c-3.6,3.6-3.6,9.5,0,13.2c3.6,3.6,9.5,3.6,13.2,0   c3.6-3.6,3.6-9.5,0-13.2C115.3,134.3,112.9,133.4,110.5,133.4z' />
					</g>
				</svg>
			<?php endif; ?>

			<?php if ( 'notify-bar-icon-3' === $banner_icon ) : ?>
				<svg viewBox="0 0 200 200" style="width: 40px; height: 40px">
					<g>
						<path
							d='M101.4,93.2c0.9,0,1.8-0.3,2.5-1L150.1,46c1.4-1.4,1.4-3.6,0-5c-1.4-1.4-3.6-1.4-4.9,0L98.9,87.2c-1.4,1.4-1.4,3.6,0,5   C99.6,92.9,100.5,93.2,101.4,93.2z' />
						<path
							d='M188.2,105.8c-3.1-5.8-9-9.3-15.5-9.3c-0.5,0-0.9,0-1.4,0.1c-0.3-1.1-0.6-2.1-1.1-3.1c-1-2.2-1.1-4.7-0.2-6.9   c0.9-2.3,2.7-4,5-4.8c6.3-2.2,10.3-8,10.3-14.6c0-6.7-4.1-12.4-10.3-14.6c-2.3-0.8-4.1-2.5-5-4.8c-0.9-2.2-0.9-4.7,0.2-6.9   c2.9-6,1.7-12.9-3-17.6c-4.7-4.7-11.6-5.9-17.6-3c-2.2,1-4.7,1.1-6.9,0.2c-2.3-0.9-4-2.7-4.8-5C135.5,9,129.8,5,123.1,5   c-3.3,0-6.4,1-9,2.8c-2.5,1.8-4.5,4.4-5.7,7.5c-0.8,2.3-2.5,4.1-4.8,5c-2.3,0.9-4.7,0.9-6.9-0.2c-6-2.9-12.9-1.7-17.6,3   c-4.7,4.7-5.9,11.6-3,17.6c1.1,2.2,1.1,4.7,0.2,6.9c-0.9,2.3-2.7,3.9-5,4.8c-6.3,2.2-10.3,8-10.3,14.6c0,6.7,4,12.4,10.3,14.6   c2.3,0.8,4.1,2.5,5,4.8c0.9,2.2,0.9,4.7-0.2,6.9c-2.1,4.4-1.9,9.1,0.4,13.5c0.3,0.6,0.7,1.2,1.1,1.8H56.7c-4.7,0-9.2,1.8-12.5,5.2   l-29.3,29.4c-3.3,3.3-5.2,7.8-5.2,12.5c0,4.7,1.8,9.2,5.2,12.5l21.5,21.5c3.3,3.3,7.8,5.2,12.5,5.2c4.7,0,9.2-1.8,12.5-5.2   l18.2-18.2c2-2,4.7-3.1,7.5-3.1h61.4c6,0,11.5-3,14.8-8l24-36.5C191,118.4,191.3,111.7,188.2,105.8z M73.6,75.2   c-4.2-1.5-5.7-5.1-5.7-8c0-2.9,1.5-6.5,5.7-8c4.1-1.5,7.5-4.6,9.1-8.7s1.6-8.6-0.3-12.6c-1.9-4-0.4-7.6,1.7-9.7s5.7-3.6,9.7-1.7   c4,1.9,8.5,2,12.6,0.3s7.2-5,8.7-9.1c1.5-4.2,5.1-5.7,8-5.7c2.9,0,6.6,1.5,8,5.7c1.5,4.1,4.6,7.5,8.7,9.1s8.6,1.6,12.6-0.3   c4-1.9,7.6-0.4,9.7,1.7c2.1,2.1,3.6,5.7,1.7,9.7c-1.9,4-2,8.6-0.3,12.6s5,7.2,9.1,8.7c4.2,1.5,5.7,5.1,5.7,8c0,2.9-1.5,6.5-5.7,8   c-4.1,1.5-7.5,4.6-9.1,8.7s-1.6,8.6,0.3,12.6c0.3,0.7,0.6,1.4,0.7,2.1c-2.7,1.4-5.1,3.5-6.8,6.2l-2.5,3.9c-0.9-0.1-1.9-0.4-2.8-0.8   c-4-1.9-8.5-2-12.6-0.3c-4,1.7-7.2,5-8.7,9.1c-0.4,1.1-1,2.1-1.8,3c-2.7-6.4-9-10.9-16.3-10.9H89.6c-2.8-0.5-5.5-2.5-6.9-5.1   c-0.9-1.6-1.6-4.2-0.2-7.2c1.9-4,2-8.5,0.3-12.6S77.7,76.7,73.6,75.2z M151.2,114.9l-8.6,13.5c-2,3.1-5.3,4.9-9,4.9h-2.9v-6   c3.2-1.8,5.7-4.7,7-8.3c0.8-2.3,2.5-4.1,4.8-5c2.2-0.9,4.7-0.9,6.9,0.2C150,114.5,150.6,114.7,151.2,114.9z M181.5,120.1l-24,36.5   c-2,3-5.3,4.8-8.9,4.8H87.2c-4.7,0-9.2,1.8-12.5,5.2l-18.2,18.3c-4.2,4.2-10.9,4.2-15.1,0l-21.5-21.6c-2-2-3.1-4.7-3.1-7.5   c0-2.9,1.1-5.5,3.1-7.6l29.3-29.3c2-2,4.7-3.1,7.5-3.1h56.3c5.9,0,10.7,4.8,10.7,10.7v6.9H86.1c-1.9,0-3.5,1.6-3.5,3.5   s1.6,3.5,3.5,3.5h47.6c6.1,0,11.6-3.1,14.9-8.2l15-23.6c2-3.1,5.3-4.9,9-4.9c4,0,7.5,2.1,9.4,5.6   C183.9,112.7,183.7,116.8,181.5,120.1z' />
						<path
							d='M140.7,96c-2.4,2.4-5.6,3.7-8.8,3.7s-6.4-1.2-8.8-3.7c-4.9-4.9-4.9-12.8,0-17.7s12.8-4.9,17.7,0S145.6,91.1,140.7,96z' />
						<path
							d='M125.9,54.9c-2.4,2.4-5.6,3.7-8.8,3.7c-3.2,0-6.4-1.2-8.8-3.7c-2.4-2.4-3.7-5.6-3.7-8.8c0-3.2,1.2-6.4,3.7-8.8   c4.9-4.9,12.8-4.9,17.7,0C130.8,42.1,130.8,50,125.9,54.9z' />
						<path
							d='M181.5,120.1l-24,36.5c-2,3-5.3,4.8-8.9,4.8H87.2c-4.7,0-9.2,1.8-12.5,5.2l-18.2,18.3c-4.2,4.2-10.9,4.2-15.1,0l-21.5-21.6   c-2-2-3.1-4.7-3.1-7.5c0-2.9,1.1-5.5,3.1-7.6l29.3-29.3c2-2,4.7-3.1,7.5-3.1h56.3c5.9,0,10.7,4.8,10.7,10.7v6.9H86.1   c-1.9,0-3.5,1.6-3.5,3.5s1.6,3.5,3.5,3.5h47.6c6.1,0,11.6-3.1,14.9-8.2l15-23.6c2-3.1,5.3-4.9,9-4.9c4,0,7.5,2.1,9.4,5.6   C183.9,112.7,183.7,116.8,181.5,120.1z' />
					</g>
				</svg>
			<?php endif; ?>
		</div>
		<div class="spsg-floating-notification-bar-text-container">
      <span class="spsg-floating-notification-bar-text">
			<?php
      /**
       * Banner text filter.
       *
       * @since 1.0.0
       */
      echo wp_kses_post( apply_filters( 'sales_boster_floating_notification_bar_text', $banner_text ) );
      ?>
		</span>
      <?php require plugin_dir_path( __FILE__ ) . 'action-button.php'; ?>
    </div>
		<div class="spsg-floating-notification-bar-remove">
			<svg width="16" height="16" viewBox="0 0 16 16">
				<g>
					<path
						d="M0.781396 16.0001C0.626858 16.0001 0.475783 15.9543 0.347281 15.8685C0.218778 15.7826 0.118621 15.6606 0.0594776 15.5178C0.000334661 15.3751 -0.0151369 15.218 0.0150198 15.0664C0.0451766 14.9148 0.119607 14.7756 0.228896 14.6664L14.6664 0.228853C14.8129 0.0823209 15.0117 0 15.2189 0C15.4261 0 15.6249 0.0823209 15.7714 0.228853C15.9179 0.375385 16.0002 0.574125 16.0002 0.781353C16.0002 0.988581 15.9179 1.18732 15.7714 1.33385L1.3339 15.7714C1.26141 15.844 1.17528 15.9016 1.08047 15.9408C0.985653 15.9801 0.884016 16.0002 0.781396 16.0001Z" />
					<path
						d="M15.2189 16.0001C15.1162 16.0002 15.0146 15.9801 14.9198 15.9408C14.825 15.9016 14.7388 15.844 14.6664 15.7714L0.228853 1.33385C0.0823209 1.18732 0 0.988581 0 0.781353C0 0.574125 0.0823209 0.375385 0.228853 0.228853C0.375385 0.0823209 0.574125 0 0.781353 0C0.988581 0 1.18732 0.0823209 1.33385 0.228853L15.7714 14.6664C15.8806 14.7756 15.9551 14.9148 15.9852 15.0664C16.0154 15.218 15.9999 15.3751 15.9408 15.5178C15.8816 15.6606 15.7815 15.7826 15.653 15.8685C15.5245 15.9543 15.3734 16.0001 15.2189 16.0001Z" />
				</g>
				<defs>
			</svg>
		</div>
	</div>
</div>
